; ===========================================================================
; AREGW.ASM
;
; Function to write to the 32 bit memory mapped and I/O registers on the
; Mach 64.
;
; Compiling:
;   masm /Ml /D<memory model> aregw.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
; ===========================================================================
IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.CODE
.386

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
            endm

; ---------------------------------------------------------------------------
; AREGW - write to a memory mapped register through VGA aperture.
;
;   This function will provide write access to the memory mapped registers
;   on all bus types. It is assumed that the VGA aperture is enabled. The
;   base address of the memory mapped registers is B000:FC00h. Each register
;   occupies 4 bytes. This is also the fastest method for real mode
;   applications.
;
; Inputs : WORD register index (stack)
;          DWORD 32 bit data (stack)
;
; Outputs: void
; ---------------------------------------------------------------------------
            public  aregw

IFDEF mem_S
aregw       proc    near
ELSE
aregw       proc    far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; --- Use VGA aperture to access memory mapped register ---
            ; Note that GUI registers on CT/ET chips must be written in
            ; 32 bit size only. Other Mach64 chips permit 8/16/32 bit sizes.
            ;

            ; save used registers
            push    si
            push    es
            push    eax

            ; write to memory mapped register
            mov     ax, 0B000h                  ; base address = B000:FC00h
            mov     es, ax
            mov     si, 0FC00h
            add     si, WORD PTR [bp+PARM]      ; get register index
            mov     eax, DWORD PTR [bp+PARM+2]  ; get full 32 bits of data
            mov     es:[si], eax                ; write it

            ; restore used registers
            pop     eax
            pop     es
            pop     si

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

aregw       endp

            end

