/*==========================================================================
* FNT7x15.C - Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL function that returns a pointer to the 7x15 interal PGL font.        *
* ======================================================================== */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

//
// Bitmap data array for 7x15 font
//
//   Width in pixels     : 7
//   Height in pixels    : 15
//   Bytes per character : 14
//   Total size in bytes : 3570
//
unsigned char pgl_fontbitmap7x15[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
	0xf4, 0x1a, 0xb0, 0x60, 0xc1, 0xbb, 0x26, 0x0b, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf7, 0xfd, 
	0x7f, 0xff, 0xff, 0xc7, 0xdf, 0xfb, 0xe0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0x6f, 0xff, 0xff, 
	0xff, 0x7c, 0x70, 0x40, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x83, 0x8f, 0xbf, 0xff, 0x7c, 
	0x70, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x83, 0x82, 0x1b, 0x77, 0x6c, 0x20, 0xe0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 
	0x8f, 0xbf, 0xff, 0x7c, 0x20, 0xe0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0e, 
	0x1c, 0x38, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xff, 0xff, 0xff, 0xff, 0xfd, 0xf1, 0xe3, 0xc7, 
	0xdf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 
	0x00, 0x01, 0x07, 0x1b, 0x36, 0x6c, 0x70, 0x40, 
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe, 
	0xf8, 0xe4, 0xc9, 0x93, 0x8f, 0xbf, 0xff, 0xff, 
	0xff, 0x80, 0x00, 0x00, 0xf0, 0xe3, 0xcd, 0x9c, 
	0x6c, 0xd9, 0xb1, 0xc0, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xe3, 0x66, 0xcd, 0x8e, 0x08, 0x7c, 
	0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x70, 0xa1, 0xc2, 0x04, 0x08, 0x10, 0xe3, 0xc3, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xb1, 0xe2, 
	0xc5, 0x9b, 0x76, 0xec, 0x98, 0x71, 0xe1, 0x80, 
	0x00, 0x00, 0x00, 0x23, 0x5b, 0xe3, 0x8d, 0x9b, 
	0x36, 0x38, 0xfb, 0x58, 0x80, 0x00, 0x00, 0x00, 
	0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7e, 0xf9, 
	0xe3, 0x86, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 
	0x30, 0xe3, 0xcf, 0xbf, 0x7e, 0x7c, 0x78, 0x70, 
	0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x41, 0xc7, 
	0xc2, 0x04, 0x08, 0x10, 0xf8, 0xe0, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0xb3, 0x66, 0xcd, 0x9b, 
	0x36, 0x6c, 0x01, 0xb3, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0xfe, 0x9d, 0x3a, 0x5c, 0xb9, 0x12, 
	0x24, 0x48, 0x90, 0x00, 0x00, 0x00, 0x00, 0xf3, 
	0x36, 0x66, 0x0f, 0x3b, 0x76, 0xdc, 0xf0, 0x66, 
	0x6c, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0xfb, 0xf7, 0xe0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x41, 0xc7, 0xc2, 0x04, 
	0x08, 0x7c, 0x70, 0x43, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x41, 0xc7, 0xc2, 0x04, 0x08, 0x10, 
	0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x40, 0x81, 0x02, 0x04, 0x08, 0x10, 0xf8, 0xe0, 
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
	0x83, 0xbf, 0xff, 0x1c, 0x30, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0e, 0x3f, 
	0xff, 0x70, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x60, 0xc1, 
	0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x8d, 0xbf, 0xff, 0x6c, 0x50, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x83, 
	0x06, 0x1e, 0x3c, 0x79, 0xfb, 0xf0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0xf7, 0xe7, 0x8f, 0x1e, 
	0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x41, 0xc3, 0x87, 0x04, 0x08, 0x10, 
	0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0xd9, 
	0xb3, 0x62, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x22, 0x4f, 
	0xc9, 0x12, 0x24, 0xfc, 0x91, 0x20, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x20, 0x43, 0xcc, 0xd8, 0x18, 
	0x38, 0x38, 0x1b, 0x33, 0xc1, 0x02, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x18, 0xb3, 0x0c, 0x30, 
	0xc3, 0x34, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xc3, 0xc7, 0x86, 0x1d, 0x36, 0xed, 0xbb, 0x63, 
	0x60, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0xc3, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x61, 0x86, 0x0c, 0x18, 
	0x30, 0x60, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0x81, 0x81, 0x83, 0x06, 0x0c, 0x18, 
	0x30, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x0c, 0xc9, 0x0c, 0x7e, 0x30, 0x93, 0x30, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0x06, 0x0c, 0x7e, 0x30, 0x60, 0xc0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x30, 0x60, 0xc3, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x7e, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc1, 
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x41, 0x86, 0x18, 0x61, 0x82, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0xe6, 0x6d, 0xdb, 0xbb, 
	0x76, 0xed, 0x9b, 0x33, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xc7, 0x83, 0x06, 0x0c, 0x18, 0x30, 
	0x60, 0xc7, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 
	0xe6, 0x6c, 0xc3, 0x04, 0x18, 0x20, 0xc3, 0x37, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe6, 0x60, 
	0xc1, 0x8e, 0x1c, 0x0c, 0x1b, 0x33, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x61, 0xc7, 0x8b, 0x36, 
	0x6c, 0xfc, 0x30, 0x60, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0xf6, 0x0c, 0x18, 0x3e, 0x0c, 0x0c, 
	0x1b, 0x33, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x01, 
	0xe6, 0x6c, 0x18, 0x3e, 0x66, 0xcd, 0x9b, 0x33, 
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf4, 0x61, 
	0x83, 0x0c, 0x18, 0x30, 0x60, 0xc1, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0xe6, 0x6c, 0xd9, 0x9e, 
	0x3c, 0xcd, 0x9b, 0x33, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0xe6, 0x6c, 0xd9, 0xb3, 0x3e, 0x0c, 
	0x1b, 0x33, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0x83, 0x00, 0x00, 0x00, 0x30, 0x60, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
	0x83, 0x00, 0x00, 0x00, 0x30, 0x60, 0xc3, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x30, 0xc3, 0x0c, 0x30, 
	0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0xfc, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x06, 0x18, 0x61, 0x86, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe6, 0x6c, 
	0xc3, 0x0c, 0x18, 0x30, 0x00, 0xc1, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0xe6, 0x6c, 0xd9, 0xb7, 
	0x6e, 0xdd, 0xb3, 0x03, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xc3, 0xcc, 0xd9, 0xb3, 0x66, 0xfd, 
	0x9b, 0x36, 0x60, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0xe3, 0x66, 0xcd, 0x9e, 0x3c, 0x6c, 0xd9, 0xb7, 
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe3, 0x6c, 
	0x18, 0x30, 0x60, 0xc1, 0x81, 0xb1, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0xc3, 0xc6, 0xcd, 0x9b, 
	0x36, 0x6c, 0xd9, 0xe7, 0x80, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0xf3, 0x66, 0x0c, 0x1e, 0x3c, 0x60, 
	0xc1, 0xb7, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0xf3, 0x66, 0x0c, 0x1e, 0x3c, 0x60, 0xc1, 0x87, 
	0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe6, 0x6c, 
	0xd8, 0x30, 0x60, 0xdd, 0x9b, 0x33, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0x36, 0x6c, 0xd9, 0xbf, 
	0x7e, 0xcd, 0x9b, 0x36, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0xe1, 0x83, 0x06, 0x0c, 0x18, 0x30, 
	0x60, 0xc3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xf0, 0xc1, 0x83, 0x06, 0x0c, 0x19, 0xb3, 0x63, 
	0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 0x36, 0x6d, 
	0x9e, 0x38, 0x70, 0xf1, 0xb3, 0x36, 0x60, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0xc3, 0x06, 0x0c, 0x18, 
	0x30, 0x60, 0xc9, 0xb7, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x16, 0x6f, 0xdf, 0xb3, 0x66, 0xcd, 
	0x9b, 0x36, 0x60, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0x36, 0x6e, 0xdd, 0xbb, 0x7e, 0xdd, 0xbb, 0x76, 
	0x60, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe6, 0x6c, 
	0xd9, 0xb3, 0x66, 0xcd, 0x9b, 0x33, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0xe3, 0x66, 0xcd, 0x9e, 
	0x30, 0x60, 0xc1, 0x87, 0x80, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0xe6, 0x6c, 0xd9, 0xb3, 0x66, 0xcd, 
	0x9b, 0xb3, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x03, 
	0xe3, 0x66, 0xcd, 0x9e, 0x38, 0x78, 0xd1, 0xb7, 
	0x60, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe6, 0x6c, 
	0x1c, 0x1c, 0x1c, 0x1c, 0x1b, 0x33, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0xf5, 0xa3, 0x06, 0x0c, 
	0x18, 0x30, 0x60, 0xc3, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0x36, 0x6c, 0xd9, 0xb3, 0x66, 0xcd, 
	0x9b, 0x33, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0x36, 0x6c, 0xd9, 0xb3, 0x66, 0xcd, 0x99, 0xe1, 
	0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 0x36, 0x6c, 
	0xd9, 0xb3, 0x66, 0xfd, 0xfb, 0x34, 0x20, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0x36, 0x67, 0x8f, 0x0c, 
	0x18, 0x78, 0xf3, 0x36, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0x36, 0x6c, 0xd9, 0x9e, 0x18, 0x30, 
	0x60, 0xc3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0xf6, 0x69, 0x83, 0x0c, 0x38, 0x61, 0x8b, 0x37, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe3, 0x06, 
	0x0c, 0x18, 0x30, 0x60, 0xc1, 0x83, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x0c, 0x0c, 
	0x0c, 0x0c, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0xe0, 0xc1, 0x83, 0x06, 0x0c, 0x18, 
	0x30, 0x63, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xc3, 0xcc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x3f, 0x80, 0x00, 0x60, 0xc1, 0x81, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x06, 0x0c, 0x79, 
	0xb3, 0x63, 0x60, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0x83, 0x06, 0x0f, 0x1b, 0x36, 0x6c, 0xd9, 0xb7, 
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0f, 0x33, 0x66, 0xc1, 0x83, 0x33, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x60, 0xc1, 0x8f, 0x36, 
	0x6c, 0xd9, 0xb3, 0x63, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x33, 0x66, 0xfd, 
	0x83, 0x33, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xe3, 0x66, 0x0c, 0x3e, 0x30, 0x60, 0xc1, 0x87, 
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0d, 0xb7, 0x66, 0xcd, 0x99, 0xf0, 0x6c, 0xcf, 
	0x00, 0x00, 0x00, 0x03, 0x83, 0x06, 0x0f, 0x1b, 
	0x36, 0x6c, 0xd9, 0xb7, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xc1, 0x80, 0x0e, 0x0c, 0x18, 0x30, 
	0x60, 0xc3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x60, 0xc0, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x66, 
	0xcd, 0x8e, 0x00, 0x00, 0x00, 0x03, 0x83, 0x06, 
	0xcd, 0x9e, 0x3c, 0x70, 0xf1, 0xb7, 0x60, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0xc1, 0x83, 0x06, 0x0c, 
	0x18, 0x30, 0x60, 0xc3, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x09, 0x3f, 0x7e, 0xcd, 
	0x9b, 0x36, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x1b, 0x1b, 0x36, 0x6c, 0xd9, 0xb3, 
	0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0f, 0x33, 0x66, 0xcd, 0x9b, 0x33, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1b, 
	0x36, 0x6c, 0xd9, 0xe3, 0x06, 0x1e, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0d, 0xb6, 0x6c, 0xd9, 
	0xb1, 0xe0, 0xc1, 0x87, 0x80, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x1b, 0x1b, 0x36, 0x60, 0xc1, 0x87, 
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0f, 0x33, 0x60, 0x70, 0x33, 0x33, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0x83, 0x06, 0x1f, 0x18, 
	0x30, 0x60, 0xc1, 0xb1, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x1b, 0x36, 0x6c, 0xd9, 
	0xb3, 0x63, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x19, 0xb3, 0x66, 0xcd, 0x99, 0xe1, 
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x19, 0xb3, 0x66, 0xcd, 0xfb, 0xf2, 0x40, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x92, 
	0x3c, 0x30, 0xf1, 0x26, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x19, 0xb3, 0x66, 0xcd, 
	0xb9, 0xb0, 0x6c, 0xcf, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x1f, 0xa3, 0x4c, 0x30, 0xc3, 0x17, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x83, 
	0x06, 0x18, 0x30, 0x30, 0x60, 0xc0, 0xe0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xc1, 0x83, 0x06, 0x00, 
	0x00, 0x30, 0x60, 0xc1, 0x80, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0xc0, 0xc1, 0x83, 0x03, 0x06, 0x18, 
	0x30, 0x63, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 
	0x94, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x0c, 0x3c, 0xcd, 0x0b, 0xf0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xe3, 0x6c, 0x18, 0x30, 
	0x60, 0xcc, 0xd8, 0xe0, 0x8d, 0x86, 0x00, 0x00, 
	0x00, 0x03, 0x36, 0x60, 0x19, 0xb3, 0x66, 0xcd, 
	0x9b, 0x73, 0x60, 0x00, 0x00, 0x00, 0x00, 0x30, 
	0x41, 0x00, 0x0f, 0x33, 0x66, 0xfd, 0x83, 0x33, 
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x41, 0xc6, 0xc0, 
	0x0e, 0x06, 0x0c, 0x79, 0xb3, 0x63, 0x60, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0x66, 0xc0, 0x0e, 0x06, 
	0x0c, 0x79, 0xb3, 0x63, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0xc0, 0x80, 0x80, 0x0e, 0x06, 0x0c, 0x79, 
	0xb3, 0x63, 0x60, 0x00, 0x00, 0x00, 0x00, 0x61, 
	0x21, 0x80, 0x0e, 0x06, 0x0c, 0x79, 0xb3, 0x63, 
	0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
	0x99, 0xb0, 0x60, 0xc1, 0x99, 0xe0, 0x85, 0x86, 
	0x00, 0x00, 0x00, 0x41, 0xc6, 0xc0, 0x0f, 0x33, 
	0x66, 0xfd, 0x83, 0x33, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0x66, 0xc0, 0x0f, 0x33, 0x66, 0xfd, 
	0x83, 0x33, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x40, 
	0x40, 0xc0, 0x0f, 0x33, 0x66, 0xfd, 0x83, 0x33, 
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x66, 0xc0, 
	0x0e, 0x0c, 0x18, 0x30, 0x60, 0xc3, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x41, 0xc6, 0xc0, 0x0e, 0x0c, 
	0x18, 0x30, 0x60, 0xc3, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0xc0, 0x80, 0x80, 0x0e, 0x0c, 0x18, 0x30, 
	0x60, 0xc3, 0xc0, 0x00, 0x00, 0x00, 0xcc, 0x00, 
	0xc3, 0xcc, 0xd9, 0xb3, 0x66, 0xfd, 0x9b, 0x36, 
	0x60, 0x00, 0x00, 0x00, 0x79, 0x99, 0xe3, 0xcc, 
	0xd9, 0xb3, 0x66, 0xfd, 0x9b, 0x36, 0x60, 0x00, 
	0x00, 0x00, 0x18, 0x61, 0x07, 0xe6, 0x0c, 0x18, 
	0x3c, 0x60, 0xc1, 0x87, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x06, 0xda, 0x44, 0x89, 0x7f, 
	0x22, 0x4b, 0x60, 0x00, 0x00, 0x00, 0x00, 0xfa, 
	0x44, 0x89, 0x12, 0x3f, 0x48, 0x91, 0x22, 0x44, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x61, 0xe6, 0x60, 
	0x0f, 0x33, 0x66, 0xcd, 0x9b, 0x33, 0xc0, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0x36, 0x60, 0x0f, 0x33, 
	0x66, 0xcd, 0x9b, 0x33, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x40, 0x40, 0xc0, 0x0f, 0x33, 0x66, 0xcd, 
	0x9b, 0x33, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x61, 
	0xe6, 0x60, 0x19, 0xb3, 0x66, 0xcd, 0x9b, 0x73, 
	0x60, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x80, 0x80, 
	0x19, 0xb3, 0x66, 0xcd, 0x9b, 0x73, 0x60, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0x36, 0x60, 0x19, 0xb3, 
	0x66, 0xcd, 0xb9, 0xb0, 0x6c, 0xcf, 0x00, 0x00, 
	0xcc, 0x01, 0xe6, 0x6c, 0xd9, 0xb3, 0x66, 0xcd, 
	0x9b, 0x33, 0xc0, 0x00, 0x00, 0x00, 0xcc, 0x03, 
	0x36, 0x6c, 0xd9, 0xb3, 0x66, 0xcd, 0x9b, 0x33, 
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x20, 0x41, 0xc6, 
	0xcc, 0x18, 0x30, 0x6c, 0x70, 0x40, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xc3, 0xc6, 0x0c, 0x3c, 
	0x30, 0x60, 0xdb, 0xb2, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x03, 0x36, 0x67, 0x86, 0x3f, 0x18, 0x78, 
	0x60, 0xc1, 0x80, 0x00, 0x00, 0x00, 0x01, 0xf3, 
	0x36, 0x6f, 0x98, 0x32, 0x6e, 0xc9, 0x93, 0x26, 
	0x60, 0x00, 0x00, 0x00, 0x00, 0x38, 0xd9, 0x83, 
	0x06, 0x3f, 0x18, 0x30, 0x60, 0xc5, 0x8f, 0x0c, 
	0x00, 0x00, 0x00, 0x30, 0x41, 0x00, 0x0e, 0x06, 
	0x0c, 0x79, 0xb3, 0x63, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0x30, 0x41, 0x00, 0x0e, 0x0c, 0x18, 0x30, 
	0x60, 0xc3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x30, 
	0x41, 0x00, 0x0f, 0x33, 0x66, 0xcd, 0x9b, 0x33, 
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x20, 0x83, 0x00, 
	0x1b, 0x36, 0x6c, 0xd9, 0xb3, 0x63, 0x60, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0x94, 0xc0, 0x17, 0x1b, 
	0x36, 0x6c, 0xd9, 0xb7, 0x60, 0x00, 0x00, 0x00, 
	0x65, 0x30, 0x06, 0x6c, 0xdd, 0xbb, 0x7e, 0xdd, 
	0xbb, 0x76, 0x60, 0x00, 0x00, 0x00, 0x00, 0x71, 
	0x22, 0x43, 0xc0, 0x1f, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x22, 0x43, 
	0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xc1, 0x80, 0x06, 0x0c, 
	0x18, 0x61, 0x9b, 0x33, 0xc0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x30, 0x60, 
	0xc1, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x1f, 0x06, 0x0c, 0x18, 0x30, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc1, 0x83, 0x26, 
	0xc3, 0x0c, 0x30, 0xd9, 0x48, 0x30, 0xc3, 0x07, 
	0x80, 0x00, 0x00, 0xc1, 0x83, 0x26, 0xc3, 0x0c, 
	0x32, 0xcd, 0x38, 0xb3, 0xe0, 0xc1, 0x80, 0x00, 
	0x00, 0x00, 0x40, 0x80, 0x02, 0x04, 0x08, 0x38, 
	0x70, 0xe0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x49, 0x24, 0x48, 0x48, 0x48, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 
	0x09, 0x09, 0x12, 0x49, 0x20, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x92, 0x90, 0x94, 0x94, 0x84, 0xa4, 
	0xa4, 0x25, 0x25, 0x21, 0x29, 0x29, 0x09, 0x00, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0xdc, 0xef, 
	0x73, 0xbd, 0xce, 0xf7, 0x3b, 0xdc, 0xef, 0x73, 
	0xbd, 0xce, 0xf7, 0x00, 0x10, 0x20, 0x40, 0x81, 
	0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x81, 0x02, 
	0x04, 0x00, 0x10, 0x20, 0x40, 0x81, 0x02, 0x04, 
	0x08, 0xf0, 0x20, 0x40, 0x81, 0x02, 0x04, 0x00, 
	0x10, 0x20, 0x40, 0x81, 0x1e, 0x04, 0x08, 0xf0, 
	0x20, 0x40, 0x81, 0x02, 0x04, 0x00, 0x28, 0x50, 
	0xa1, 0x42, 0x85, 0x0a, 0x14, 0xe8, 0x50, 0xa1, 
	0x42, 0x85, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xf8, 0x50, 0xa1, 0x42, 0x85, 
	0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x04, 
	0x08, 0xf0, 0x20, 0x40, 0x81, 0x02, 0x04, 0x00, 
	0x28, 0x50, 0xa1, 0x42, 0x9d, 0x02, 0x04, 0xe8, 
	0x50, 0xa1, 0x42, 0x85, 0x0a, 0x00, 0x28, 0x50, 
	0xa1, 0x42, 0x85, 0x0a, 0x14, 0x28, 0x50, 0xa1, 
	0x42, 0x85, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x1f, 0x02, 0x04, 0xe8, 0x50, 0xa1, 0x42, 0x85, 
	0x0a, 0x00, 0x28, 0x50, 0xa1, 0x42, 0x9d, 0x02, 
	0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x28, 0x50, 0xa1, 0x42, 0x85, 0x0a, 0x14, 0xf8, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 
	0x40, 0x81, 0x1e, 0x04, 0x08, 0xf0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xf0, 0x20, 0x40, 0x81, 0x02, 
	0x04, 0x00, 0x10, 0x20, 0x40, 0x81, 0x02, 0x04, 
	0x08, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x10, 0x20, 0x40, 0x81, 0x02, 0x04, 0x08, 0xfe, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x20, 0x40, 
	0x81, 0x02, 0x04, 0x00, 0x10, 0x20, 0x40, 0x81, 
	0x02, 0x04, 0x08, 0x1e, 0x20, 0x40, 0x81, 0x02, 
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x10, 0x20, 0x40, 0x81, 0x02, 0x04, 0x08, 0xfe, 
	0x20, 0x40, 0x81, 0x02, 0x04, 0x00, 0x10, 0x20, 
	0x40, 0x81, 0x03, 0xc4, 0x08, 0x1e, 0x20, 0x40, 
	0x81, 0x02, 0x04, 0x00, 0x28, 0x50, 0xa1, 0x42, 
	0x85, 0x0a, 0x14, 0x2e, 0x50, 0xa1, 0x42, 0x85, 
	0x0a, 0x00, 0x28, 0x50, 0xa1, 0x42, 0x85, 0xc8, 
	0x10, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x07, 0xc8, 0x10, 0x2e, 
	0x50, 0xa1, 0x42, 0x85, 0x0a, 0x00, 0x28, 0x50, 
	0xa1, 0x42, 0x9d, 0xc0, 0x00, 0xfe, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x1f, 0xc0, 0x00, 0xee, 0x50, 0xa1, 0x42, 0x85, 
	0x0a, 0x00, 0x28, 0x50, 0xa1, 0x42, 0x85, 0xc8, 
	0x10, 0x2e, 0x50, 0xa1, 0x42, 0x85, 0x0a, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0xfe, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x50, 
	0xa1, 0x42, 0x9d, 0xc0, 0x00, 0xee, 0x50, 0xa1, 
	0x42, 0x85, 0x0a, 0x00, 0x10, 0x20, 0x40, 0x81, 
	0x1f, 0xc0, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x28, 0x50, 0xa1, 0x42, 0x85, 0x0a, 
	0x14, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0xfe, 
	0x20, 0x40, 0x81, 0x02, 0x04, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x50, 0xa1, 
	0x42, 0x85, 0x0a, 0x00, 0x28, 0x50, 0xa1, 0x42, 
	0x85, 0x0a, 0x14, 0x3e, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x10, 0x20, 0x40, 0x81, 0x03, 0xc4, 
	0x08, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc4, 0x08, 0x1e, 
	0x20, 0x40, 0x81, 0x02, 0x04, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x50, 0xa1, 
	0x42, 0x85, 0x0a, 0x00, 0x28, 0x50, 0xa1, 0x42, 
	0x85, 0x0a, 0x14, 0xfe, 0x50, 0xa1, 0x42, 0x85, 
	0x0a, 0x00, 0x10, 0x20, 0x40, 0x81, 0x1f, 0xc4, 
	0x08, 0xfe, 0x20, 0x40, 0x81, 0x02, 0x04, 0x00, 
	0x10, 0x20, 0x40, 0x81, 0x02, 0x04, 0x08, 0xf0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x40, 
	0x81, 0x02, 0x04, 0x00, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 
	0xe1, 0xc3, 0x87, 0x0e, 0x1c, 0x38, 0x70, 0xe1, 
	0xc3, 0x87, 0x0e, 0x1c, 0x38, 0x00, 0x1e, 0x3c, 
	0x78, 0xf1, 0xe3, 0xc7, 0x8f, 0x1e, 0x3c, 0x78, 
	0xf1, 0xe3, 0xc7, 0x80, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xdf, 0x36, 
	0x6c, 0xd9, 0xb3, 0xe3, 0x60, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x07, 0x1b, 0x34, 0x78, 0xf9, 
	0x9b, 0xb6, 0xcc, 0x18, 0x00, 0x00, 0x00, 0x03, 
	0xf3, 0x66, 0x4c, 0x18, 0x30, 0x60, 0xc1, 0x83, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x1f, 0x92, 0x24, 0x48, 0x91, 0x22, 0x40, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0xf6, 0x66, 0x46, 0x06, 
	0x0c, 0x30, 0xcb, 0x37, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xb4, 0x6c, 0xd9, 
	0xb3, 0x63, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x06, 0xcd, 0x9b, 0x36, 0x6c, 0xf1, 0x86, 
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0d, 0xb6, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0xf1, 0x87, 0x99, 0xb3, 
	0x66, 0xcc, 0xf0, 0xc7, 0xe0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xc3, 0xcc, 0xd9, 0xbf, 0x7e, 0xcd, 
	0x99, 0xe1, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xc3, 0xcc, 0xd0, 0xa1, 0x66, 0x48, 0x91, 0x26, 
	0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf3, 0x02, 
	0x07, 0x1b, 0x66, 0xcd, 0x9b, 0x63, 0x80, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xb5, 
	0xc9, 0xd6, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x30, 0xc7, 0x9b, 0xb7, 0x76, 0xec, 
	0xf1, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xe3, 0x0c, 0x18, 0x3e, 0x60, 0xc1, 0x81, 0x81, 
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe6, 0x6c, 
	0xd9, 0xb3, 0x66, 0xcd, 0x9b, 0x36, 0x60, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 
	0x00, 0xfc, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0x02, 0x1f, 0x08, 0x10, 
	0x01, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
	0x81, 0x81, 0x81, 0x83, 0x0c, 0x30, 0xc0, 0x03, 
	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xc3, 
	0x0c, 0x18, 0x18, 0x18, 0x18, 0x03, 0xe0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc6, 0x8c, 
	0x18, 0x30, 0x60, 0xc1, 0x83, 0x06, 0x0c, 0x00, 
	0x30, 0x60, 0xc1, 0x83, 0x06, 0x0c, 0x18, 0x30, 
	0x62, 0xc7, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x81, 0x00, 0x1f, 0x3e, 0x00, 0x20, 0x40, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0d, 0xb6, 0x00, 0x00, 0xdb, 0x60, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0xc6, 0xcd, 0x8e, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 
	0x02, 0x04, 0x08, 0x11, 0xa1, 0xc1, 0x81, 0x00, 
	0x00, 0x00, 0x01, 0xb1, 0xa2, 0x44, 0x89, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xc2, 0x41, 0x04, 0x1e, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x07, 0xcf, 0x9f, 0x3e, 0x7c, 0xf9, 0xf0, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00
};

//
// Static PGL font structure for 7x15 font
//
PGL_font pgl_fixedfont7x15[] =
{
    7,  // character width
    15, // character height
    {   // character index array

        0x0000, 0x000e, 0x001c, 0x002a, 0x0038, 0x0046, 0x0054, 0x0062,
        0x0070, 0x007e, 0x008c, 0x009a, 0x00a8, 0x00b6, 0x00c4, 0x00d2, 
        0x00e0, 0x00ee, 0x00fc, 0x010a, 0x0118, 0x0126, 0x0134, 0x0142, 
        0x0150, 0x015e, 0x016c, 0x017a, 0x0188, 0x0196, 0x01a4, 0x01b2, 
        0x0000, 0x01c0, 0x01ce, 0x01dc, 0x01ea, 0x01f8, 0x0206, 0x0214, 
        0x0222, 0x0230, 0x023e, 0x024c, 0x025a, 0x0268, 0x0276, 0x0284, 
        0x0292, 0x02a0, 0x02ae, 0x02bc, 0x02ca, 0x02d8, 0x02e6, 0x02f4, 
        0x0302, 0x0310, 0x031e, 0x032c, 0x033a, 0x0348, 0x0356, 0x0364, 
        0x0372, 0x0380, 0x038e, 0x039c, 0x03aa, 0x03b8, 0x03c6, 0x03d4, 
        0x03e2, 0x03f0, 0x03fe, 0x040c, 0x041a, 0x0428, 0x0436, 0x0444, 
        0x0452, 0x0460, 0x046e, 0x047c, 0x048a, 0x0498, 0x04a6, 0x04b4, 
        0x04c2, 0x04d0, 0x04de, 0x04ec, 0x04fa, 0x0508, 0x0516, 0x0524, 
        0x0532, 0x0540, 0x054e, 0x055c, 0x056a, 0x0578, 0x0586, 0x0594, 
        0x05a2, 0x05b0, 0x05be, 0x05cc, 0x05da, 0x05e8, 0x05f6, 0x0604, 
        0x0612, 0x0620, 0x062e, 0x063c, 0x064a, 0x0658, 0x0666, 0x0674, 
        0x0682, 0x0690, 0x069e, 0x06ac, 0x06ba, 0x06c8, 0x06d6, 0x06e4, 
        0x06f2, 0x0700, 0x070e, 0x071c, 0x072a, 0x0738, 0x0746, 0x0754, 
        0x0762, 0x0770, 0x077e, 0x078c, 0x079a, 0x07a8, 0x07b6, 0x07c4, 
        0x07d2, 0x07e0, 0x07ee, 0x07fc, 0x080a, 0x0818, 0x0826, 0x0834, 
        0x0842, 0x0850, 0x085e, 0x086c, 0x087a, 0x0888, 0x0896, 0x08a4, 
        0x08b2, 0x08c0, 0x08ce, 0x08dc, 0x08ea, 0x08f8, 0x0906, 0x0914, 
        0x0922, 0x0930, 0x093e, 0x094c, 0x095a, 0x0968, 0x0976, 0x0984, 
        0x0992, 0x09a0, 0x09ae, 0x09bc, 0x09ca, 0x09d8, 0x09e6, 0x09f4, 
        0x0a02, 0x0a10, 0x0a1e, 0x0a2c, 0x0a3a, 0x0a48, 0x0a56, 0x0a64, 
        0x0a72, 0x0a80, 0x0a8e, 0x0a9c, 0x0aaa, 0x0ab8, 0x0ac6, 0x0ad4, 
        0x0ae2, 0x0af0, 0x0afe, 0x0b0c, 0x0b1a, 0x0b28, 0x0b36, 0x0b44, 
        0x0b52, 0x0b60, 0x0b6e, 0x0b7c, 0x0b8a, 0x0b98, 0x0ba6, 0x0bb4, 
        0x0bc2, 0x0bd0, 0x0bde, 0x0bec, 0x0bfa, 0x0c08, 0x0c16, 0x0c24, 
        0x0c32, 0x0c40, 0x0c4e, 0x0c5c, 0x0c6a, 0x0c78, 0x0c86, 0x0c94, 
        0x0ca2, 0x0cb0, 0x0cbe, 0x0ccc, 0x0cda, 0x0ce8, 0x0cf6, 0x0d04, 
        0x0d12, 0x0d20, 0x0d2e, 0x0d3c, 0x0d4a, 0x0d58, 0x0d66, 0x0d74, 
        0x0d82, 0x0d90, 0x0d9e, 0x0dac, 0x0dba, 0x0dc8, 0x0dd6, 0x0000
    },
    pgl_fontbitmap7x15, // pointer to bitmap data array
    NULL                // reserved
};

/* --------------------------------------------------------------------------
  PGL_getfixedfont7x15 - returns a pointer to the PGL internal 7x15 font

  This function returns a "PGL_font" pointer to the PGL's internal 7x15 font
  structure. This function is useful if loading a font file is not desired as
  with PGL_loadfont(). It is also always available. It should be noted that
  using this function will add the static font structure to the size of the
  application. Since this function returns a pointer instead of filling a
  given PGL_font structure, the application must access the font structure
  elements using '->' (instead of '.' as with PGL_loadfont()).
-------------------------------------------------------------------------- */
PGL_font *PGL_getfixedfont7x15(void)
{
    return (pgl_fixedfont7x15);
}

