/******************************************************************************
 * mach64 Chapter 6 sample code                                               *
 *                                                                            *
 * mix.c - This program uses the mach64 engine to illustrate how the          *
 * mixing feature is used.                                                    *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#include <stdio.h>
#include "..\util\atim64.h"
#include "..\util\defines.h"
#include "..\util\main.h"

/******************************************************************************
 * Main Program to demonstrate mixing                                         *
 *  Function: The rectangle pattern from rect.c is drawn on the screen.       *
 *            The mixing feature of the mach64 is demonstrated by             *
 *            drawing a LIGHT GREEN rectangle over most of the existing       *
 *            screen, but setting the foreground mix to DST_OR_SRC.           *
 *            Default setting of the foreground mix is just SRC.              *
 *    Inputs: Arguments for mode spatial and colour resolution                *
 *   Outputs: NONE                                                            *
 ******************************************************************************/

void main (int argc, char *argv[])
{
    int width;                          // Width of drawing area.
    int height;                         // Height of drawing area.
    int i;                              // Counter for rows of rectangles.
    int j;                              // Counter for columns of rectangles.
    int n;                              // # rectangles in x and y direction.
    int m_width;                        // Width of mix rectangle.
    int m_height;                       // Height of mix rectangle.

    printf ("mach64 Chapter 6 sample code\n"
            "\n"
            "mix.c\n"
            "The rectangle pattern from rect.c is drawn on the screen. The mixing\n"
            "feature of the mach64 is demonstrated by drawing a LIGHT GREEN\n"
            "rectangle over most of the existing screen, but setting the foreground\n"
            "mix to DST_OR_SRC.  Default setting of the foreground mix is just SRC.\n"
            "Try experimenting by setting different mixes and different colours.\n"
            "\n"
            "Spatial resolution (640, 800, 1024, 1280, 1600) and Colour Depth\n"
            "(8, 15, 16, 24, 32) should be passed as arguments.\n"
            "Default setting is 640x480 spatial resolution and 8bpp pixel depth.\n");

    // Batch command to detect the mach64, perform a hardware query, Save old
    // mode information, process mode info arguments, load and set mode, enable
    // aperture, set up palettes, initialize engine to known state, and reset
    // all engine queues.
    start (argc, argv);

    // Set up values.
    width = 640;                        // Less than or equal to xres.
    height = 480;                       // Less than or equal to yres.
    n=4;                                // > 0 ,<= min (width, height).
    m_width = width*5/6;                // Less than or equal to xres.
    m_height = height*5/6;              // Less than or equal to yres.

    // 16 different coloured rectangles are drawn on the screen corresponding
    // to the first 16 EGA standard palette colours.

    clear_screen (0, 0, MODE_INFO.xres, MODE_INFO.yres);

    for (i=0; i<n; i++)
    {
        for (j=0; j<n; j++)
        {
            wait_for_fifo (1);
            regw (DP_FRGD_CLR, get_colour_code ((n*i + j)%NUM_COLOURS));
            draw_rectangle (((MODE_INFO.xres - width)/2)+(j*width/n),
                            ((MODE_INFO.yres - height)/2)+(i*height/n),
                            width/n, height/n);
        } // for
    } // for

    // Wait for a carriage return (show screen before operation).
    getch ();

    // Set mixes (defines for all mixes are located in ..\util\defines.h)
    //    Foreground mix is set to destination OR source.
    //    Background mix is set to destination.

    wait_for_fifo (1);
    regw (DP_MIX, (BKGD_MIX_D | FRGD_MIX_D_OR_S));

    // Draw LIGHTGREEN rectangle over existing rectangles (slightly smaller).

    wait_for_fifo (1);
    regw (DP_FRGD_CLR, get_colour_code (LIGHTGREEN));
    draw_rectangle ((MODE_INFO.xres - m_width)/2, (MODE_INFO.yres - m_height)/2,
                    m_width, m_height);

    // Wait for a carriage return.
    getch ();

    // Batch command to restore old mode.
    finish ();

    exit (0);                           // No errors.

} // main
