/*==========================================================================
* VGAFONT.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved *
*                                                                          *
* PGL functions to use the VGA 8x8, 8x14, and 8x16 fonts.                  *       *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_vgafont - fill given PGL font structure with VGA font data

  This function fills the given PGL font structure depending on the given
  VGA font size to use.
-------------------------------------------------------------------------- */
int PGL_vgafont(int vgafontsize, PGL_font *font)
{
    int retval, romcode, index;
    unsigned int offset;

    // assume error
    retval = YES_ERROR;

    // if VGA controller is disabled, return error
    if (PGL_querydata.vga_type != VGA_ENABLE)
    {
        return (YES_ERROR);
    }

    // get setup information
    font->bit_data = NULL;
    font->unload_ptr = NULL;
    switch(vgafontsize)
    {
        case VGAFONT_8x8:
            romcode = 3;
            font->charwidth = 8;
            font->charheight = 8;
            break;

        case VGAFONT_8x14:
            romcode = 2;
            font->charwidth = 8;
            font->charheight = 14;
            break;

        case VGAFONT_8x16:
            romcode = 6;
            font->charwidth = 8;
            font->charheight = 16;
            break;
    }

    // call ROM to get font address
    font->bit_data = pgl_getfontaddress(romcode);
    if (font->bit_data != NULL)
    {
        // load index table
        offset = 0;
        for (index = 0; index < 256; index++)
        {
            font->index[index] = offset;
            offset = offset + (unsigned int)(font->charheight);
        }
        retval = NO_ERROR;
    }

    return (retval);
}

