/*==========================================================================
* QUERY.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved   *
*                                                                          *
* PGL query functions.                                                     *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_getquerysize - get the buffer size required to hold query information
  
  This function returns the buffer size in bytes required to hold the query
  information when calling PGL_queryhardware(). The size is retrieved by
  calling the Mach64 ROM. This size depends on the type of query information
  required - HEADER_ONLY or HEADER_AND_MODE. If zero is returned, an error
  has occured.
-------------------------------------------------------------------------- */
int PGL_getquerysize(int fill_type)
{
    int buffer_size;

    // get query size in bytes
    buffer_size = ROM_getquerysize(fill_type);

    return (buffer_size);
}

/* --------------------------------------------------------------------------
  PGL_queryhardware - query the Mach 64 hardware
  
  The given buffer is filled with hardware information. There are two types
  of fills - HEADER_ONLY or HEADER_AND_MODE. The information is retrieved by
  calling the Mach64 ROM. PGL_getquerysize() should be called by the
  application to insure that the buffer size is correct.

  Return codes:

    NO_ERROR      - the query structure has been successfully filled
    YES_ERROR     - an error has occurred
-------------------------------------------------------------------------- */
int PGL_queryhardware(int fill_type, void far *querybuffer)
{
    PGL_queryheader far *queryptr;
    int error;

    // assume error
    error = YES_ERROR;

    // fill query buffer
    if (ROM_fillquerystructure(fill_type, querybuffer) == NO_ERROR)
    {
        // set no error condition
        error = NO_ERROR;

        // mask off unwanted bits
        queryptr = (PGL_queryheader far *)(querybuffer);

        queryptr->vga_type = (unsigned char)(queryptr->vga_type & 0x01);
        queryptr->memory_size = (unsigned char)(queryptr->memory_size & 0x07);
        queryptr->dac_type = (unsigned char)(queryptr->dac_type & 0xff);
        queryptr->memory_type = (unsigned char)(queryptr->memory_type & 0x07);
        queryptr->bus_type = (unsigned char)(queryptr->bus_type & 0x07);
        queryptr->monitor_cntl = (unsigned char)(queryptr->monitor_cntl & 0xc0);
        queryptr->ramdac_feature_support = (unsigned char)(queryptr->ramdac_feature_support & 0xf0);
    }

    return (error);
}

