/*==========================================================================
  SCISSOR.C

  Example code to show effect of engine scissors.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    int dstx, dsty, dstwidth, dstheight;
    unsigned long left, right, top, bottom;

    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // setup engine context and clear screen
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // setup rectangle size
    dstx = modeinfo.xres / 16;
    dsty = modeinfo.yres / 16;
    dstwidth = modeinfo.xres - (2 * (modeinfo.xres / 16));
    dstheight = modeinfo.yres - (2 * (modeinfo.yres / 16));

    // Set the scissors to the size of the screen mode (inclusive)

    left = 0;
    top = 0;
    right = modeinfo.xres - 1;
    bottom = modeinfo.yres - 1;

    // Adjust parameters if 24 bpp.
    if (modeinfo.bpp == 24)
    {
        left = left * 3;
        right = right * 3;
    }

    wait_for_fifo (4);
    regw (SC_LEFT, left);
    regw (SC_TOP, top);
    regw (SC_RIGHT, right);
    regw (SC_BOTTOM, bottom);

    // Draw a WHITE filled rectangle
    set_fg_color (get_color_code (WHITE));
    draw_rectangle (dstx, dsty, dstwidth, dstheight);

    // wait for a carriage return
    getch ();

    // Set the scissors to a slightly smaller size than the drawn rectangle
    left = 2 * (modeinfo.xres / 16);
    top = 2 * (modeinfo.yres / 16);
    right = modeinfo.xres - (2 * (modeinfo.xres / 16));
    bottom = modeinfo.yres - (2 * (modeinfo.yres / 16));

    // Adjust parameters if 24 bpp.
    if (modeinfo.bpp == 24)
    {
        left = left * 3;
        right = right * 3;
    }

    wait_for_fifo (4);
    regw (SC_LEFT, left);
    regw (SC_TOP, top);
    regw (SC_RIGHT, right);
    regw (SC_BOTTOM, bottom);

    // Draw a LIGHTRED filled rectangle of the same size as the previous one.
    // The outer border of the rectangle will be clipped by the scissors.
    set_fg_color (get_color_code (LIGHTRED));
    draw_rectangle (dstx, dsty, dstwidth, dstheight);

    // wait for a carriage return
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

