/******************************************************************************
 * Header file for PCI functions.                                             *
 *                                                                            *
 * Copyright (c) 1993-1997 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#ifndef _PCI_H
#define _PCI_H

// Function constants.

#define PCI_FUNCTION_ID         0xB1
#define PCI_BIOS_PRESENT        0x01
#define FIND_PCI_DEVICE         0x02
#define FIND_PCI_CLASS_CODE     0x03
#define GENERATE_SPECIAL_CYCLE  0x06
#define READ_CONFIG_BYTE        0x08
#define READ_CONFIG_WORD        0x09
#define READ_CONFIG_DWORD       0x0A
#define WRITE_CONFIG_BYTE       0x0B
#define WRITE_CONFIG_WORD       0x0C
#define WRITE_CONFIG_DWORD      0x0D

// PCI function error codes.

#define SUCCESSFUL              0x00
#define FUNC_NOT_SUPPORTED      0x81
#define BAD_VENDOR_ID           0x83
#define DEVICE_NOT_FOUND        0x86
#define BAD_REGISTER_NUMBER     0x87

// ATI vendor and device IDs.

#define VENDOR_ID 0x1002
#define DEVICE_ID 0x4758

unsigned pci_device_ID[] = {
					0x5654, // VT
					0x5656, // VT4
					0x4754, // 3D RAGE I, II
					0x4755, // 3D RAGE II+
					0x4756, // 3D RAGE IIC (PQFP, PCI 33 MHz)
					0x475A, // 3D RAGE IIC (PQFP, PCI 66 MHz)
					0x4757, // 3D RAGE IIC (BGA, PCI 66 MHz)
					0x4759, // 3D RAGE IIC (BGA, PCI 33 MHz)
					0x4742, // 3D RAGE PRO (BGA package, AGP1x2x)
					0x4744, // 3D RAGE PRO (BGA package, AGP1x only)
					0x4749, // 3D RAGE PRO (BGA package, PCI 33 MHz only)
					0x4750, // 3D RAGE PRO (PQFP package, PCI)
					0x4751, // 3D RAGE PRO (PQFP package, PCI, limited 3D)
				};

#define MAX_CHIP_IDS 13

// PCI user structures.
// Ensure that all structures are BYTE aligned.

#pragma pack(1)

// PCI system information.

typedef struct pciinfo
{
	int present_status;
	int hw_mechanism;
	int ver_maj;
	int ver_min;
	int pci_bus_num;
} PCI_INFO;

// PCI device information.

typedef struct pcideviceinfo
{
	unsigned char bus_num;
	unsigned char device_num;
} PCI_DEVICE_INFO;

// Resume default alignment.

#pragma pack()

// PCI routines used in pci.c

int pci_bios_present (PCI_INFO far *);
int pci_find_device (unsigned int, unsigned int, unsigned int,
					 PCI_DEVICE_INFO far *);
unsigned char pci_read_config_byte (unsigned int, PCI_DEVICE_INFO far *);

#endif // _PCI_H
