/*==========================================================================
* SAVESCN.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved *
*                                                                          *
* PGL functions to save and restore text screen contents.                  *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  getcursorposition - retrieve the current cursor position

  Returns Y coordinate in upper 8 bits of 'position',
          X coordinate in lower 8 bits of 'position'
          starting line in upper 8 bits of 'cursortype',
          ending line in lower 8 bits of 'cursortype'.
-------------------------------------------------------------------------- */
void getcursorposition(unsigned int *position, unsigned int *cursortype)
{
    union REGS regs;

    // get cursor position and type
    regs.h.ah = 3;
    regs.h.bh = 0;
    int86(0x10, &regs, &regs);
    *position = regs.x.dx;
    *cursortype = regs.x.cx;
}

/* --------------------------------------------------------------------------
  setcursorposition - set the current cursor position

  Inputs : Y coordinate in upper 8 bits of 'position',
           X coordinate in lower 8 bits of 'position',
           starting line in upper 8 bits of 'cursortype',
           ending line in lower 8 bits of 'cursortype'.
-------------------------------------------------------------------------- */
void setcursorposition(unsigned int position, unsigned int cursortype)
{
    union REGS regs;

    // set cursor position
    regs.h.ah = 2;
    regs.h.bh = 0;
    regs.x.dx = position;
    int86(0x10, &regs, &regs);

    // set cursor type
    regs.h.ah = 1;
    regs.h.bh = 0;
    regs.x.cx = cursortype;
    int86(0x10, &regs, &regs);
}

/* --------------------------------------------------------------------------
  savetextscreen - save contents of text screen
-------------------------------------------------------------------------- */
void savetextscreen(unsigned int mode, unsigned int *buffer)
{
    unsigned int far *vidaddr;
    unsigned int index;

    if (mode == 7)
    {
        // mono text mode address
        vidaddr = (unsigned int far *)(0xb0000000);
    }
    else
    {
        // color text mode address
        vidaddr = (unsigned int far *)(0xb8000000);
    }

    // read screen data and store it in buffer
    for (index = 0; index < 2000; index++)
    {
        *(buffer + index) = *((unsigned int far *)(vidaddr + index));
    }
}

/* --------------------------------------------------------------------------
  restoretextscreen - restore contents of text screen
-------------------------------------------------------------------------- */
void restoretextscreen(unsigned int mode, unsigned int *buffer)
{
    unsigned int far *vidaddr;
    unsigned int index;

    if (mode == 7)
    {
        // mono text mode address
        vidaddr = (unsigned int far *)(0xb0000000);
    }
    else
    {
        // color text mode address
        vidaddr = (unsigned int far *)(0xb8000000);
    }

    // write screen data from buffer
    for (index = 0; index < 2000; index++)
    {
        *((unsigned int far *)(vidaddr + index)) = *(buffer + index);
    }
}

